/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.http.SecurityHandler;

class DefaultSecurityHandler
implements SecurityHandler {
    private String message = "<html><body><p style=\"text-align:justify\"><b>Java can''t verify the identity of the website \"{0}\".</b></p><p style=\"text-align:justify;font:11\">The certificate for this website was signed by an unknown certifying authority, or was self-signed. You might be connecting to a website that is pretending to be \"{0}\", which could put your confidential information at risk. Would you like to connect to the website anyway?</p></body></html>";
    private boolean accepted = false;
    private JEditorPane messagePane;

    DefaultSecurityHandler() {
    }

    private JDialog createDialog() {
        final JDialog dlg = new JDialog();
        dlg.setModal(true);
        this.messagePane = new JEditorPane();
        this.messagePane.setContentType("text/html");
        this.messagePane.setEditable(false);
        this.messagePane.setOpaque(false);
        this.messagePane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        AbstractAction continueAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DefaultSecurityHandler.this.accepted = true;
                dlg.setVisible(false);
            }
        };
        continueAction.putValue("Name", "Continue");
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DefaultSecurityHandler.this.accepted = false;
                dlg.setVisible(false);
            }
        };
        cancelAction.putValue("Name", "Cancel");
        AbstractAction showCertAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        showCertAction.putValue("Name", "Show Certificate");
        JLabel iconLabel = new JLabel(new ImageIcon(this.getClass().getResource("resources/security-warning.png")));
        JButton continueButton = new JButton(continueAction);
        JButton cancelButton = new JButton(cancelAction);
        JButton showCertButton = new JButton(showCertAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(continueButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(showCertButton);
        dlg.add(iconLabel);
        dlg.add(this.messagePane);
        dlg.add(buttonPanel);
        GridBagLayout gbl = new GridBagLayout();
        gbl.addLayoutComponent(iconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(0, 24, 0, 0), 0, 0));
        gbl.addLayoutComponent(this.messagePane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 24, 0, 11), 0, 0));
        gbl.addLayoutComponent(buttonPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 15, 2, new Insets(24, 12, 11, 11), 0, 0));
        dlg.setLayout(gbl);
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.addLayoutComponent(showCertButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelLayout.addLayoutComponent(cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelLayout.addLayoutComponent(continueButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.setLayout(panelLayout);
        dlg.setDefaultCloseOperation(2);
        dlg.setSize(535, 185);
        return dlg;
    }

    public boolean isServerTrusted(String host, X509Certificate cert) {
        this.accepted = false;
        JDialog dlg = this.createDialog();
        this.messagePane.setText(MessageFormat.format(this.message, host));
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        return this.accepted;
    }
}

