/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DataToolHeader
extends AbstractTeXObject
implements TeXObject {
    private DataToolSty sty;
    private int column;
    private String key;
    private DatumType type;
    private TeXObject title;
    public static final byte TYPE_UNDEF = -1;
    public static final byte TYPE_STRING = 0;
    public static final byte TYPE_INT = 1;
    public static final byte TYPE_REAL = 2;
    public static final byte TYPE_CURRENCY = 3;
    public static final byte TYPE_DATETIME = 4;
    public static final byte TYPE_DATE = 5;
    public static final byte TYPE_TIME = 6;

    public DataToolHeader(DataToolSty dataToolSty, int n, String string) {
        this(dataToolSty, n, string, -1, null);
    }

    public DataToolHeader(DataToolSty dataToolSty, int n, String string, DatumType datumType, TeXObject teXObject) {
        this.sty = dataToolSty;
        this.setColumnIndex(n);
        this.setColumnLabel(string);
        this.setType(datumType);
        this.setTitle(teXObject);
    }

    public DataToolHeader(DataToolSty dataToolSty, int n, String string, byte by, TeXObject teXObject) {
        this(dataToolSty, n, string, DatumType.toDatumType(by), teXObject);
    }

    @Override
    public Object clone() {
        return new DataToolHeader(this.sty, this.column, this.key, this.type, this.title == null ? null : (TeXObject)this.title.clone());
    }

    public int getColumnIndex() {
        return this.column;
    }

    public void setColumnIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid column index " + n);
        }
        this.column = n;
    }

    public String getColumnLabel() {
        return this.key;
    }

    public void setColumnLabel(String string) {
        this.key = string;
    }

    public byte getType() {
        return (byte)this.type.getValue();
    }

    public DatumType getDataType() {
        return this.type;
    }

    public TeXNumber getNumericalType(TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = this.type.getCs(teXParser.getListener());
        if (controlSequence instanceof TeXNumber) {
            return (TeXNumber)((Object)controlSequence);
        }
        return new UserNumber(this.type.getValue());
    }

    public void setType(DatumType datumType) {
        this.type = datumType;
    }

    public void setType(byte by) {
        this.setType(DatumType.toDatumType(by));
    }

    public void updateType(DataElement dataElement) {
        this.setType(DatumType.getDominant(dataElement.getDatumType(), this.type));
    }

    public TeXObject getTitle() {
        return this.title;
    }

    public void setTitle(TeXObject teXObject) {
        this.title = teXObject;
    }

    public static DataToolHeader popHeader(TeXParser teXParser, TeXObjectList teXObjectList, DataToolSty dataToolSty) throws IOException {
        byte by;
        TeXObject teXObject = teXObjectList.peekStack(TeXObjectList.POP_IGNORE_LEADING_SPACE);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof DataToolHeader) {
            return (DataToolHeader)teXObjectList.popToken(TeXObjectList.POP_IGNORE_LEADING_SPACE);
        }
        if (!teXObjectList.popCsMarker(teXParser, "db@plist@elt@w")) {
            return null;
        }
        teXObjectList.popCsMarker(teXParser, "db@col@id@w");
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        int n = numerical.number(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@col@id@end@");
        teXObjectList.popCsMarker(teXParser, "db@key@id@w");
        TeXObjectList teXObjectList2 = teXObjectList.popToCsMarker(teXParser, "db@key@id@end@");
        String string = teXObjectList2.toString(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@type@id@w");
        teXObjectList2 = teXObjectList.popToCsMarker(teXParser, "db@type@id@end@");
        String string2 = teXObjectList2.toString(teXParser).trim();
        if (string2.isEmpty()) {
            by = -1;
        } else {
            try {
                by = Byte.parseByte(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TeXSyntaxException(teXParser, "tex.error.number_expected", string2);
            }
        }
        teXObjectList.popCsMarker(teXParser, "db@header@id@w");
        teXObjectList2 = teXObjectList.popToCsMarker(teXParser, "db@header@id@end@");
        teXObjectList.popCsMarker(teXParser, "db@col@id@w");
        numerical = teXObjectList.popNumerical(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@col@id@end@");
        int n2 = numerical.number(teXParser);
        if (n != n2) {
            throw new LaTeXSyntaxException(teXParser, "datatool.mismatched", String.format("\\db@col@id@w %d\\db@col@id@end@", n), String.format("\\db@col@id@w %d\\db@col@id@end@", n2));
        }
        teXObjectList.popCsMarker(teXParser, "db@plist@elt@end@");
        try {
            return new DataToolHeader(dataToolSty, n, string, by, (TeXObject)teXObjectList2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "latex.package.error", illegalArgumentException.getMessage());
        }
    }

    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("db@plist@elt@w"));
        teXObjectList.add(new TeXCsRef("db@col@id@w"));
        teXObjectList.add(new UserNumber(this.column));
        teXObjectList.add(new TeXCsRef("db@col@id@end@"));
        teXObjectList.add(new TeXCsRef("db@key@id@w"));
        teXObjectList.add(teXParser.getListener().createString(this.key));
        teXObjectList.add(new TeXCsRef("db@key@id@end@"));
        teXObjectList.add(new TeXCsRef("db@type@id@w"));
        teXObjectList.add(new UserNumber(this.type.getValue()));
        teXObjectList.add(new TeXCsRef("db@type@id@end@"));
        teXObjectList.add(new TeXCsRef("db@header@id@w"));
        if (this.title == null) {
            teXObjectList.add(teXParser.getListener().createString(this.key));
        } else {
            teXObjectList.add((TeXObject)this.title.clone());
        }
        teXObjectList.add(new TeXCsRef("db@header@id@end@"));
        teXObjectList.add(new TeXCsRef("db@col@id@w"));
        teXObjectList.add(new UserNumber(this.column));
        teXObjectList.add(new TeXCsRef("db@col@id@end@"));
        teXObjectList.add(new TeXCsRef("db@plist@elt@end@"));
        return teXObjectList;
    }

    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.expandonce(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.addAll(0, this.expandonce(teXParser, teXObjectList));
    }

    @Override
    public String toString(TeXParser teXParser) {
        try {
            return this.expandonce(teXParser).toString(teXParser);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).string(teXParser);
    }

    @Override
    public String format() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).format();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataToolHeader)) {
            return false;
        }
        DataToolHeader dataToolHeader = (DataToolHeader)object;
        if (this.column != dataToolHeader.column || this.type != dataToolHeader.type) {
            return false;
        }
        if (!this.key.equals(dataToolHeader.key)) {
            return false;
        }
        if (this.title != null && dataToolHeader.title != null && this.title.equals(dataToolHeader.title)) {
            return true;
        }
        return this.title == dataToolHeader.title;
    }

    public String toString() {
        return String.format("%s[column=%d,key=%s,type=%s,title=%s]", new Object[]{this.getClass().getSimpleName(), this.column, this.key, this.type, this.title});
    }
}

