/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPartition
extends SingleLineCommand2<ActivityDiagram> {
    public CommandPartition() {
        super(CommandPartition.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPartition.class.getName(), RegexLeaf.start(), new RegexLeaf("partition"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), RegexLeaf.spaceZeroOrMore(), new RegexOr(CommandPartition.color().getRegex(), new RegexLeaf("LEGACYCOLORIGNORED", "(#[0-9a-fA-F]{6}|#?\\w+)?")), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("\\{?"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(arg.get("NAME", 0)));
        diagram.gotoGroup(location, quark, Display.getWithNewlines(diagram.getPragma(), quark.getName()), GroupType.PACKAGE);
        Entity p = diagram.getCurrentGroup();
        Colors colors = CommandPartition.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        if (!colors.isEmpty()) {
            p.setColors(colors);
        }
        p.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
        return CommandExecutionResult.ok();
    }
}

