/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import org.havi.ui.HGraphicsDevice;
import org.havi.ui.HScene;
import org.havi.ui.HSceneTemplate;
import org.havi.ui.HScreen;
import org.videolan.BDJXletContext;
import org.videolan.GUIManager;
import org.videolan.Logger;

public class HSceneFactory {
    private HScene defaultHScene = null;
    private static final Logger logger = Logger.getLogger(HSceneFactory.class.getName());

    private HSceneFactory() {
    }

    public static HSceneFactory getInstance() {
        BDJXletContext context = BDJXletContext.getCurrentContext();
        if (context != null) {
            if (context.getSceneFactory() == null) {
                context.setSceneFactory(new HSceneFactory());
            }
            return context.getSceneFactory();
        }
        logger.error("getInstance(): no context at " + Logger.dumpStack());
        return null;
    }

    public HSceneTemplate getBestSceneTemplate(HSceneTemplate template) {
        logger.unimplemented("getBestSceneTemplate");
        return null;
    }

    public HScene getBestScene(HSceneTemplate template) {
        return this.getDefaultHScene();
    }

    public HSceneTemplate resizeScene(HScene scene, HSceneTemplate template) throws IllegalStateException {
        logger.unimplemented("resizeScene");
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HScene getDefaultHScene(HScreen screen) {
        Class<HSceneFactory> clazz = HSceneFactory.class;
        synchronized (HSceneFactory.class) {
            if (this.defaultHScene == null) {
                this.defaultHScene = new HScene();
                this.defaultHScene.setLocation(0, 0);
                this.defaultHScene.setSize(GUIManager.getInstance().getWidth(), GUIManager.getInstance().getHeight());
                GUIManager.getInstance().add(this.defaultHScene);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.defaultHScene;
        }
    }

    public HScene getDefaultHScene() {
        return this.getDefaultHScene(HScreen.getDefaultHScreen());
    }

    public HScene getFullScreenScene(HGraphicsDevice device) {
        return this.getDefaultHScene();
    }

    public void dispose(HScene scene) {
        if (scene == null) {
            logger.error("null HScene");
            return;
        }
        if (this.defaultHScene == null) {
            return;
        }
        if (!scene.equals(this.defaultHScene)) {
            logger.error("wrong HScene");
        }
        scene.disposeImpl();
        GUIManager.getInstance().remove(scene);
        this.defaultHScene = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<HSceneFactory> clazz = HSceneFactory.class;
        synchronized (HSceneFactory.class) {
            if (this.defaultHScene != null) {
                this.dispose(this.defaultHScene);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

