/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.flattr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import org.fibs.geotag.gui.flattr.FlattrImageLoader;
import org.fibs.geotag.util.BrowserLauncher;

public class FlattrButton
extends JButton {
    private static final String FLATTR = "flattr";

    public FlattrButton() {
        this("http://flattr.com/thing/141685/Geotag");
    }

    public FlattrButton(final String flattrUrl) {
        super("Flattr this!");
        PropertyChangeListener imageListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE.equals(event.getNewValue())) {
                    FlattrButton.this.setIcon(FlattrImageLoader.getImageIcon());
                    FlattrButton.this.setText(null);
                }
            }
        };
        ImageIcon imageIcon = FlattrImageLoader.getImageIcon(imageListener);
        if (imageIcon != null) {
            this.setIcon(imageIcon);
            this.setText(null);
        }
        this.setActionCommand(FLATTR);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FlattrButton.FLATTR.equals(actionEvent.getActionCommand())) {
                    BrowserLauncher.openURL(null, flattrUrl);
                }
            }
        });
    }
}

